function Traffic() {
	this.cars = [];

	this.crossroads = [{}, //0
		{
			position: {
				x: 580,
				y: 1440
			},
			eastNorth: 1,
			eastSouth: null,
			westNorth: 2,
			westSouth: null
		}, //1
		{
			position: {
				x: 897,
				y: 1260
			},
			eastNorth: 4,
			eastSouth: 3,
			westNorth: null,
			westSouth: 1
		}, //2
		{
			position: {
				x: 1241,
				y: 1460
			},
			eastNorth: 6,
			eastSouth: null,
			westNorth: 3,
			westSouth: null
		}, //3
		{
			position: {
				x: 1428,
				y: 1352
			},
			eastNorth: 7,
			eastSouth: null,
			westNorth: 5,
			westSouth: 6
		}, //4
		{
			position: {
				x: 1084,
				y: 1154
			},
			eastNorth: 10,
			eastSouth: 5,
			westNorth: 106,
			westSouth: 4
		}, //5
		{
			position: {
				x: 1428,
				y: 956
			},
			eastNorth: 13,
			eastSouth: 9,
			westNorth: 66,
			westSouth: 10
		}, //6
		{
			position: {
				x: 1584,
				y: 1045
			},
			eastNorth: 12,
			eastSouth: 8,
			westNorth: 9,
			westSouth: null
		}, //7
		{
			position: {
				x: 1769,
				y: 1154
			},
			eastNorth: 11,
			eastSouth: null,
			westNorth: 8,
			westSouth: 7
		}, //8
		{
			position: {
				x: 1770,
				y: 935
			},
			eastNorth: 62,
			eastSouth: 14,
			westNorth: null,
			westSouth: 12
		}, //9
		{
			position: {
				x: 1957,
				y: 1044
			},
			eastNorth: 60,
			eastSouth: 15,
			westNorth: 14,
			westSouth: 11
		}, //10
		{
			position: {
				x: 2300,
				y: 845
			},
			eastNorth: null,
			eastSouth: 59,
			westNorth: 58,
			westSouth: 60
		}, //11
		{
			position: {
				x: 2112,
				y: 736
			},
			eastNorth: 42,
			eastSouth: 58,
			westNorth: 57,
			westSouth: 61
		}, //12
		{
			position: {
				x: 1925,
				y: 844
			},
			eastNorth: 61,
			eastSouth: null,
			westNorth: 63,
			westSouth: 62
		}, //13
		{
			position: {
				x: 1770,
				y: 755
			},
			eastNorth: 64,
			eastSouth: 63,
			westNorth: null,
			westSouth: 13
		}, //14
		{
			position: {
				x: 1956,
				y: 646
			},
			eastNorth: null,
			eastSouth: 57,
			westNorth: 56,
			westSouth: 64
		}, //15
		{
			position: {
				x: 1926,
				y: 628
			},
			eastNorth: 44,
			eastSouth: 56,
			westNorth: 55,
			westSouth: null
		}, //16
		{
			position: {
				x: 1772,
				y: 540
			},
			eastNorth: null,
			eastSouth: 55,
			westNorth: 54,
			westSouth: 65
		}, //17
		{
			position: {
				x: 1240,
				y: 847
			},
			eastNorth: 65,
			eastSouth: 66,
			westNorth: 67,
			westSouth: null
		}, //18
		{
			position: {
				x: 1052,
				y: 738
			},
			eastNorth: null,
			eastSouth: 67,
			westNorth: 68,
			westSouth: 87
		}, //19
		{
			position: {
				x: 865,
				y: 629
			},
			eastNorth: 53,
			eastSouth: 68,
			westNorth: 71,
			westSouth: null
		}, //20
		{
			position: {
				x: 818,
				y: 601
			},
			eastNorth: null,
			eastSouth: 71,
			westNorth: 83,
			westSouth: 69
		}, //21
		{
			position: {
				x: 475,
				y: 800
			},
			eastNorth: null,
			eastSouth: 72,
			westNorth: 73,
			westSouth: 105
		}, //22
		{
			position: {
				x: 520,
				y: 828
			},
			eastNorth: 70,
			eastSouth: 107,
			westNorth: 72,
			westSouth: null
		}, //23
		{
			position: {
				x: 336,
				y: 936
			},
			eastNorth: 104,
			eastSouth: 81,
			westNorth: 80,
			westSouth: null
		}, //24
		{
			position: {
				x: 288,
				y: 909
			},
			eastNorth: null,
			eastSouth: 80,
			westNorth: null,
			westSouth: 75
		}, //25
		{
			position: {
				x: 181,
				y: 1026
			},
			eastNorth: 77,
			eastSouth: 78,
			westNorth: null,
			westSouth: null
		}, //26
		{
			position: {
				x: 521,
				y: 1044
			},
			eastNorth: 84,
			eastSouth: 82,
			westNorth: 81,
			westSouth: null
		}, //27
		{
			position: {
				x: 710,
				y: 935
			},
			eastNorth: 87,
			eastSouth: 85,
			westNorth: 107,
			westSouth: 84
		}, //28
		{
			position: {
				x: 897,
				y: 1044
			},
			eastNorth: null,
			eastSouth: 106,
			westNorth: 85,
			westSouth: 86
		}, //29
		{
			position: {
				x: 708,
				y: 1153
			},
			eastNorth: 86,
			eastSouth: null,
			westNorth: 82,
			westSouth: null
		}, //30
		{
			position: {
				x: 396,
				y: 1152
			},
			eastNorth: null,
			eastSouth: null,
			westNorth: 78,
			westSouth: 79
		}, //31
		{
			position: {
				x: 242,
				y: 1243
			},
			eastNorth: 79,
			eastSouth: 2,
			westNorth: null,
			westSouth: null
		}, //32
		{
			position: {
				x: 1347,
				y: 294
			},
			eastNorth: null,
			eastSouth: 50,
			westNorth: 51,
			westSouth: 52
		}, //33
		{
			position: {
				x: 1395,
				y: 321
			},
			eastNorth: 49,
			eastSouth: 54,
			westNorth: 50,
			westSouth: null
		}, //34
		{
			position: {
				x: 1628,
				y: 130
			},
			eastNorth: null,
			eastSouth: 46,
			westNorth: 47,
			westSouth: 48
		}, //35
		{
			position: {
				x: 1678,
				y: 158
			},
			eastNorth: null,
			eastSouth: 45,
			westNorth: 46,
			westSouth: null
		}, //36
		{
			position: {
				x: 2208,
				y: 466
			},
			eastNorth: 43,
			eastSouth: null,
			westNorth: 45,
			westSouth: 44
		}, //37
		{
			position: {
				x: 2394,
				y: 357
			},
			eastNorth: 38,
			eastSouth: 35,
			westNorth: null,
			westSouth: 43
		}, //38
		{
			position: {
				x: 2442,
				y: 329
			},
			eastNorth: null,
			eastSouth: null,
			westNorth: 36,
			westSouth: 38
		}, //39
		{
			position: {
				x: 2580,
				y: 464
			},
			eastNorth: 39,
			eastSouth: 33,
			westNorth: null,
			westSouth: 42
		}, //40
		{
			position: {
				x: 2628,
				y: 438
			},
			eastNorth: null,
			eastSouth: null,
			westNorth: 34,
			westSouth: 39
		}, //41
		{
			position: {
				x: 2925,
				y: 665
			},
			eastNorth: 40,
			eastSouth: 31,
			westNorth: null,
			westSouth: 41
		}, //42
		{
			position: {
				x: 2973,
				y: 637
			},
			eastNorth: null,
			eastSouth: null,
			westNorth: 32,
			westSouth: 40
		}, //43
		{
			position: {
				x: 2457,
				y: 936
			},
			eastNorth: 41,
			eastSouth: null,
			westNorth: 59,
			westSouth: null
		}, //44
		{
			position: {
				x: 3423,
				y: 953
			},
			eastNorth: null,
			eastSouth: 19,
			westNorth: null,
			westSouth: 17
		}, //45
		{
			position: {
				x: 3471,
				y: 926
			},
			eastNorth: null,
			eastSouth: null,
			westNorth: 30,
			westSouth: 21
		}, //46
		{
			position: {
				x: 3471,
				y: 981
			},
			eastNorth: 20,
			eastSouth: null,
			westNorth: 19,
			westSouth: null
		}, //47
		{
			position: {
				x: 3518,
				y: 953
			},
			eastNorth: 24,
			eastSouth: null,
			westNorth: 22,
			westSouth: null
		}, //48
		{
			position: {
				x: 2613,
				y: 1424
			},
			eastNorth: null,
			eastSouth: 16,
			westNorth: 15,
			westSouth: 28
		}, //49
		{
			position: {
				x: 2662,
				y: 1452
			},
			eastNorth: 18,
			eastSouth: 27,
			westNorth: 16,
			westSouth: null
		}, //50
		{
			position: {
				x: 1718,
				y: -91
			},
			eastNorth: null,
			eastSouth: null,
			westNorth: 88,
			westSouth: null
		}, //51
		{
			position: {
				x: 1622,
				y: -91
			},
			eastNorth: null,
			eastSouth: 37,
			westNorth: 89,
			westSouth: null
		}, //52
		{
			position: {
				x: 1247,
				y: -91
			},
			eastNorth: null,
			eastSouth: 47,
			westNorth: 90,
			westSouth: null
		}, //53
		{
			position: {
				x: 682,
				y: -91
			},
			eastNorth: 90,
			eastSouth: 51,
			westNorth: 91,
			westSouth: null
		}, //54
		{
			position: {
				x: -91,
				y: -91
			},
			eastNorth: 91,
			eastSouth: null,
			westNorth: null,
			westSouth: 92
		}, //55
		{
			position: {
				x: -91,
				y: 75
			},
			eastNorth: null,
			eastSouth: 83,
			westNorth: 92,
			westSouth: 93
		}, //56
		{
			position: {
				x: -91,
				y: 472
			},
			eastNorth: null,
			eastSouth: 73,
			westNorth: 93,
			westSouth: 94
		}, //57
		{
			position: {
				x: -91,
				y: 1130
			},
			eastNorth: null,
			eastSouth: null,
			westNorth: null,
			westSouth: 94
		}, //58
		{
			position: {
				x: -91,
				y: 1186
			},
			eastNorth: 76,
			eastSouth: null,
			westNorth: null,
			westSouth: 95
		}, //59
		{
			position: {
				x: -91,
				y: 2250
			},
			eastNorth: null,
			eastSouth: 96,
			westNorth: 95,
			westSouth: null
		}, //60
		{
			position: {
				x: 1190,
				y: 2250
			},
			eastNorth: null,
			eastSouth: 97,
			westNorth: null,
			westSouth: 95
		}, //61
		{
			position: {
				x: 1286,
				y: 2250
			},
			eastNorth: 29,
			eastSouth: 98,
			westNorth: null,
			westSouth: 97
		}, //62
		{
			position: {
				x: 4040,
				y: 2250
			},
			eastNorth: null,
			eastSouth: 99,
			westNorth: 27,
			westSouth: 98
		}, //63
		{
			position: {
				x: 4182,
				y: 2250
			},
			eastNorth: 100,
			eastSouth: null,
			westNorth: null,
			westSouth: 99
		}, //64
		{
			position: {
				x: 4182,
				y: 1400
			},
			eastNorth: 101,
			eastSouth: 100,
			westNorth: null,
			westSouth: null
		}, //65
		{
			position: {
				x: 4182,
				y: 1336
			},
			eastNorth: 102,
			eastSouth: 101,
			westNorth: 25,
			westSouth: null
		}, //66
		{
			position: {
				x: 4182,
				y: 566
			},
			eastNorth: 103,
			eastSouth: 102,
			westNorth: null,
			westSouth: null
		}, //67
		{
			position: {
				x: 4182,
				y: 510
			},
			eastNorth: null,
			eastSouth: 103,
			westNorth: null,
			westSouth: 23
		}, //68
	];

	this.roads = [{}, //0
		{
			s1: 1,
			s2: 2,
			carsToFirst: [],
			carsToSecond: []
		}, //1
		{
			s1: 1,
			s2: 32,
			carsToFirst: [],
			carsToSecond: []
		}, //2
		{
			s1: 3,
			s2: 2,
			carsToFirst: [],
			carsToSecond: []
		}, //3
		{
			s1: 5,
			s2: 2,
			carsToFirst: [],
			carsToSecond: []
		}, //4
		{
			s1: 5,
			s2: 4,
			carsToFirst: [],
			carsToSecond: []
		}, //5
		{
			s1: 3,
			s2: 4,
			carsToFirst: [],
			carsToSecond: []
		}, //6
		{
			s1: 4,
			s2: 8,
			carsToFirst: [],
			carsToSecond: []
		}, //7
		{
			s1: 8,
			s2: 7,
			carsToFirst: [],
			carsToSecond: []
		}, //8
		{
			s1: 7,
			s2: 6,
			carsToFirst: [],
			carsToSecond: []
		}, //9
		{
			s1: 5,
			s2: 6,
			carsToFirst: [],
			carsToSecond: []
		}, //10
		{
			s1: 8,
			s2: 10,
			carsToFirst: [],
			carsToSecond: []
		}, //11
		{
			s1: 9,
			s2: 7,
			carsToFirst: [],
			carsToSecond: []
		}, //12
		{
			s1: 6,
			s2: 14,
			carsToFirst: [],
			carsToSecond: []
		}, //13
		{
			s1: 9,
			s2: 10,
			carsToFirst: [],
			carsToSecond: []
		}, //14
		{
			s1: 10,
			s2: 49,
			carsToFirst: [],
			carsToSecond: []
		}, //15
		{
			s1: 50,
			s2: 49,
			carsToFirst: [],
			carsToSecond: []
		}, //16
		{
			s1: 49,
			s2: 45,
			carsToFirst: [],
			carsToSecond: []
		}, //17
		{
			s1: 50,
			s2: 47,
			carsToFirst: [],
			carsToSecond: []
		}, //18
		{
			s1: 45,
			s2: 47,
			carsToFirst: [],
			carsToSecond: []
		}, //19
		{
			s1: 47,
			s2: 48,
			carsToFirst: [],
			carsToSecond: []
		}, //20
		{
			s1: 45,
			s2: 46,
			carsToFirst: [],
			carsToSecond: []
		}, //21
		{
			s1: 46,
			s2: 48,
			carsToFirst: [],
			carsToSecond: []
		}, //22
		{
			s1: 46,
			s2: 68,
			carsToFirst: [],
			carsToSecond: []
		}, //23
		{
			s1: 48,
			s2: 67,
			carsToFirst: [],
			carsToSecond: []
		}, //24
		{
			s1: 48,
			s2: 66,
			carsToFirst: [],
			carsToSecond: []
		}, //25
		{
			s1: 47,
			s2: 65,
			carsToFirst: [],
			carsToSecond: []
		}, //26
		{
			s1: 50,
			s2: 63,
			carsToFirst: [],
			carsToSecond: []
		}, //27
		{
			s1: 61,
			s2: 49,
			carsToFirst: [],
			carsToSecond: []
		}, //28
		{
			s1: 50,
			s2: 62,
			carsToFirst: [],
			carsToSecond: []
		}, //29
		{
			s1: 43,
			s2: 46,
			carsToFirst: [],
			carsToSecond: []
		}, //30
		{
			s1: 42,
			s2: 45,
			carsToFirst: [],
			carsToSecond: []
		}, //31
		{
			s1: 41,
			s2: 43,
			carsToFirst: [],
			carsToSecond: []
		}, //32
		{
			s1: 40,
			s2: 42,
			carsToFirst: [],
			carsToSecond: []
		}, //33
		{
			s1: 39,
			s2: 41,
			carsToFirst: [],
			carsToSecond: []
		}, //34
		{
			s1: 38,
			s2: 40,
			carsToFirst: [],
			carsToSecond: []
		}, //35
		{
			s1: 39,
			s2: 51,
			carsToFirst: [],
			carsToSecond: []
		}, //36
		{
			s1: 38,
			s2: 52,
			carsToFirst: [],
			carsToSecond: []
		}, //37
		{
			s1: 38,
			s2: 39,
			carsToFirst: [],
			carsToSecond: []
		}, //38
		{
			s1: 40,
			s2: 41,
			carsToFirst: [],
			carsToSecond: []
		}, //39
		{
			s1: 42,
			s2: 43,
			carsToFirst: [],
			carsToSecond: []
		}, //40
		{
			s1: 42,
			s2: 44,
			carsToFirst: [],
			carsToSecond: []
		}, //41
		{
			s1: 12,
			s2: 40,
			carsToFirst: [],
			carsToSecond: []
		}, //42
		{
			s1: 37,
			s2: 38,
			carsToFirst: [],
			carsToSecond: []
		}, //43
		{
			s1: 37,
			s2: 16,
			carsToFirst: [],
			carsToSecond: []
		}, //44
		{
			s1: 36,
			s2: 37,
			carsToFirst: [],
			carsToSecond: []
		}, //45
		{
			s1: 35,
			s2: 36,
			carsToFirst: [],
			carsToSecond: []
		}, //46
		{
			s1: 35,
			s2: 53,
			carsToFirst: [],
			carsToSecond: []
		}, //47
		{
			s1: 35,
			s2: 33,
			carsToFirst: [],
			carsToSecond: []
		}, //48
		{
			s1: 34,
			s2: 36,
			carsToFirst: [],
			carsToSecond: []
		}, //49
		{
			s1: 34,
			s2: 33,
			carsToFirst: [],
			carsToSecond: []
		}, //50
		{
			s1: 54,
			s2: 33,
			carsToFirst: [],
			carsToSecond: []
		}, //51
		{
			s1: 21,
			s2: 33,
			carsToFirst: [],
			carsToSecond: []
		}, //52
		{
			s1: 20,
			s2: 34,
			carsToFirst: [],
			carsToSecond: []
		}, //53
		{
			s1: 17,
			s2: 34,
			carsToFirst: [],
			carsToSecond: []
		}, //54
		{
			s1: 17,
			s2: 16,
			carsToFirst: [],
			carsToSecond: []
		}, //55
		{
			s1: 15,
			s2: 16,
			carsToFirst: [],
			carsToSecond: []
		}, //56
		{
			s1: 15,
			s2: 12,
			carsToFirst: [],
			carsToSecond: []
		}, //57
		{
			s1: 11,
			s2: 12,
			carsToFirst: [],
			carsToSecond: []
		}, //58
		{
			s1: 11,
			s2: 44,
			carsToFirst: [],
			carsToSecond: []
		}, //59
		{
			s1: 11,
			s2: 10,
			carsToFirst: [],
			carsToSecond: []
		}, //60
		{
			s1: 12,
			s2: 13,
			carsToFirst: [],
			carsToSecond: []
		}, //61
		{
			s1: 9,
			s2: 13,
			carsToFirst: [],
			carsToSecond: []
		}, //62
		{
			s1: 14,
			s2: 13,
			carsToFirst: [],
			carsToSecond: []
		}, //63
		{
			s1: 14,
			s2: 15,
			carsToFirst: [],
			carsToSecond: []
		}, //64
		{
			s1: 18,
			s2: 17,
			carsToFirst: [],
			carsToSecond: []
		}, //65
		{
			s1: 18,
			s2: 6,
			carsToFirst: [],
			carsToSecond: []
		}, //66
		{
			s1: 18,
			s2: 19,
			carsToFirst: [],
			carsToSecond: []
		}, //67
		{
			s1: 20,
			s2: 19,
			carsToFirst: [],
			carsToSecond: []
		}, //68
		{
			s1: 21,
			s2: 22,
			carsToFirst: [],
			carsToSecond: []
		}, //69
		{
			s1: 20,
			s2: 23,
			carsToFirst: [],
			carsToSecond: []
		}, //70
		{
			s1: 20,
			s2: 21,
			carsToFirst: [],
			carsToSecond: []
		}, //71
		{
			s1: 23,
			s2: 22,
			carsToFirst: [],
			carsToSecond: []
		}, //72
		{
			s1: 57,
			s2: 22,
			carsToFirst: [],
			carsToSecond: []
		}, //73
		{
			s1: 23,
			s2: 22,
			carsToFirst: [],
			carsToSecond: []
		}, //74.............
		{
			s1: 58,
			s2: 25,
			carsToFirst: [],
			carsToSecond: []
		}, //75
		{
			s1: 59,
			s2: 26,
			carsToFirst: [],
			carsToSecond: []
		}, //76
		{
			s1: 24,
			s2: 26,
			carsToFirst: [],
			carsToSecond: []
		}, //77
		{
			s1: 26,
			s2: 31,
			carsToFirst: [],
			carsToSecond: []
		}, //78
		{
			s1: 32,
			s2: 31,
			carsToFirst: [],
			carsToSecond: []
		}, //79
		{
			s1: 24,
			s2: 25,
			carsToFirst: [],
			carsToSecond: []
		}, //80
		{
			s1: 24,
			s2: 27,
			carsToFirst: [],
			carsToSecond: []
		}, //81
		{
			s1: 30,
			s2: 27,
			carsToFirst: [],
			carsToSecond: []
		}, //82
		{
			s1: 56,
			s2: 21,
			carsToFirst: [],
			carsToSecond: []
		}, //83
		{
			s1: 28,
			s2: 27,
			carsToFirst: [],
			carsToSecond: []
		}, //84
		{
			s1: 28,
			s2: 29,
			carsToFirst: [],
			carsToSecond: []
		}, //85
		{
			s1: 30,
			s2: 29,
			carsToFirst: [],
			carsToSecond: []
		}, //86
		{
			s1: 28,
			s2: 19,
			carsToFirst: [],
			carsToSecond: []
		}, //87
		{
			s1: 51,
			s2: 52,
			carsToFirst: [],
			carsToSecond: []
		}, //88
		{
			s1: 52,
			s2: 53,
			carsToFirst: [],
			carsToSecond: []
		}, //89
		{
			s1: 53,
			s2: 54,
			carsToFirst: [],
			carsToSecond: []
		}, //90
		{
			s1: 55,
			s2: 54,
			carsToFirst: [],
			carsToSecond: []
		}, //91
		{
			s1: 55,
			s2: 56,
			carsToFirst: [],
			carsToSecond: []
		}, //92
		{
			s1: 57,
			s2: 56,
			carsToFirst: [],
			carsToSecond: []
		}, //93
		{
			s1: 57,
			s2: 58,
			carsToFirst: [],
			carsToSecond: []
		}, //94
		{
			s1: 60,
			s2: 59,
			carsToFirst: [],
			carsToSecond: []
		}, //95
		{
			s1: 60,
			s2: 61,
			carsToFirst: [],
			carsToSecond: []
		}, //96
		{
			s1: 62,
			s2: 61,
			carsToFirst: [],
			carsToSecond: []
		}, //97
		{
			s1: 62,
			s2: 63,
			carsToFirst: [],
			carsToSecond: []
		}, //98
		{
			s1: 64,
			s2: 63,
			carsToFirst: [],
			carsToSecond: []
		}, //99
		{
			s1: 64,
			s2: 65,
			carsToFirst: [],
			carsToSecond: []
		}, //100
		{
			s1: 65,
			s2: 66,
			carsToFirst: [],
			carsToSecond: []
		}, //101
		{
			s1: 67,
			s2: 66,
			carsToFirst: [],
			carsToSecond: []
		}, //102
		{
			s1: 67,
			s2: 68,
			carsToFirst: [],
			carsToSecond: []
		}, //103
		{
			s1: 24,
			s2: 23,
			carsToFirst: [],
			carsToSecond: []
		}, //104
		{
			s1: 25,
			s2: 22,
			carsToFirst: [],
			carsToSecond: []
		}, //105
		{
			s1: 29,
			s2: 5,
			carsToFirst: [],
			carsToSecond: []
		}, //106
		{
			s1: 23,
			s2: 28,
			carsToFirst: [],
			carsToSecond: []
		}, //107

	];

	this.availableRoads = [];
	for (a = 1; a < this.roads.length; a++) {
		if (a == 74)
			continue;
		this.availableRoads.push(a);
	}
	this.lastCrossroad = 0;
	this.pedestrianCrossingOffset = 30;
	this.roadCount = this.roads.length; //67
	this.crossroadOffset = 57;
	this.g = null;
	this.s = null;
	this.numerOfNewElements = 0;

	var traffic = this;
	setInterval(function() {
		var currDate = new Date();
		for (var i = 0; i < traffic.crossroads.length; i++) {
			var carsOnCrossroad = traffic.getCarsOnCrossroadWaiting(i);
			for (var j = 0; j < carsOnCrossroad.length; j++) {
				if ((currDate - traffic.cars[carsOnCrossroad[j]].waitingStartTime) > 2000 && traffic.wakeWaitingCarIfPossible(carsOnCrossroad[j], j, carsOnCrossroad)) {
					traffic.cars[carsOnCrossroad[j]].changeDirection();
					//console.log(carsOnCrossroad[j]);
					continue;
				}
			}
			//traffic.wakeRandomWaitingCar(i);
		}
	}, 2000);
}

Traffic.prototype.reorientCar = function(car, roadId) {
	roadId %= this.roads.length;
	var crossroadPosition;
	if (car.goesToSecondCrossroad) {
		crossroadPosition = this.crossroads[this.roads[roadId].s1].position;
	} else {
		crossroadPosition = this.crossroads[this.roads[roadId].s2].position;
	}

	var carPosition = {
		x: car.bitmap.x,
		y: car.bitmap.y
	};

	var orientation = this.orientationFromPoints(crossroadPosition, carPosition);

	if (orientation == "northWest") {
		car.bitmap.x += car.northWestOffset.x;
		car.bitmap.y += car.northWestOffset.y;
	} else if (orientation == "southEast") {
		car.bitmap.x += car.southEastOffset.x;
		car.bitmap.y += car.southEastOffset.y;
	} else if (orientation == "northEast") {
		car.bitmap.x += car.northEastOffset.x;
		car.bitmap.y += car.northEastOffset.y;
	} else if (orientation == "southWest") {
		car.bitmap.x += car.southWestOffset.x;
		car.bitmap.y += car.southWestOffset.y;
	}

	car.bitmap.gotoAndPlay(orientation);
}

Traffic.prototype.orientationFromPoints = function(firstPoint, secondPoint) {
	var oriantation = "";

	if (firstPoint.x >= secondPoint.x && firstPoint.y >= secondPoint.y) {
		oriantation = "northWest";
	} else if (firstPoint.x <= secondPoint.x && firstPoint.y <= secondPoint.y) {
		oriantation = "southEast";
	} else if (firstPoint.x <= secondPoint.x && firstPoint.y >= secondPoint.y) {
		oriantation = "northEast";
	} else if (firstPoint.x >= secondPoint.x && firstPoint.y <= secondPoint.y) {
		oriantation = "southWest";
	}

	return oriantation;
}

Traffic.prototype.addCar = function(car) {

	this.cars.push(car);
	if (this.lastCrossroad > this.roads.length)
		car.goesToSecondCrossroad = false;
	else
		car.goesToSecondCrossroad = true;

	//if(this.lastCrossroad%this.availableRoads.length==1)
	//	this.lastCrossroad++;

	car.bitmap.x = (this.crossroads[this.roads[this.availableRoads[this.lastCrossroad % this.availableRoads.length]].s1].position.x + this.crossroads[this.roads[this.availableRoads[this.lastCrossroad % this.availableRoads.length]].s2].position.x) / 2;
	car.bitmap.y = (this.crossroads[this.roads[this.availableRoads[this.lastCrossroad % this.availableRoads.length]].s1].position.y + this.crossroads[this.roads[this.availableRoads[this.lastCrossroad % this.availableRoads.length]].s2].position.y) / 2;
	//console.log(car.bitmap.x+" "+car.bitmap.y);
	if (car.goesToSecondCrossroad)
		this.roads[this.availableRoads[this.lastCrossroad % this.availableRoads.length]].carsToSecond.push(this.cars.length - 1);
	else
		this.roads[this.availableRoads[this.lastCrossroad % this.availableRoads.length]].carsToFirst.push(this.cars.length - 1);

	this.reorientCar(car, this.availableRoads[this.lastCrossroad % this.availableRoads.length], this.cars.length - 1);

	this.lastCrossroad++;
}

Traffic.prototype.handleTraffic = function() {
	var logString = "";
	for (var i = 1; i < this.roads.length; i++) {
		if (i == 74 || this.crossroads[this.roads[i].s1] == undefined || this.crossroads[this.roads[i].s2] == undefined || this.crossroads[this.roads[i].s1].position == undefined || this.crossroads[this.roads[i].s2].position == undefined)
			continue;

		//crossroads positions
		var firstCrossroadPosition = this.crossroads[this.roads[i].s1].position;
		var secondCrossroadPosition = this.crossroads[this.roads[i].s2].position;
		var firstCrossroadPositionVector = new Vector([firstCrossroadPosition.x, firstCrossroadPosition.y]);
		var secondCrossroadPositionVector = new Vector([secondCrossroadPosition.x, secondCrossroadPosition.y]);

		//calculating translation (speed) vector for car
		var translationVector = secondCrossroadPositionVector.subtract(firstCrossroadPositionVector);
		translationVector.normalize();
		translationVector = translationVector.multiply(new Vector([3, 3]));

		//out of map
		if (i >= 88 && i <= 103)
			translationVector = translationVector.multiply(new Vector([50, 50]));

		var j = 0;

		//for each car going to second crossroad
		for (j = 0; j < this.roads[i].carsToSecond.length; j++) {
			var vehiclePosition = this.cars[this.roads[i].carsToSecond[j]].getOriginalPosition();

			var crossroadIndex = this.roads[i].s2;

			vehicleCrossroadSegment = secondCrossroadPositionVector.subtract(new Vector([vehiclePosition.x, vehiclePosition.y]));
			vehicleCrossroadSegmentOpposite = vehicleCrossroadSegment.multiply(new Vector([-1, -1]));
			vehicleCrossroadSegmentOpposite.normalize();
			vehicleCrossroadSegmentOpposite = vehicleCrossroadSegmentOpposite.multiply(new Vector([this.crossroadOffset, this.crossroadOffset]));

			var crosswalkPositionVector = secondCrossroadPositionVector.add(vehicleCrossroadSegmentOpposite);
			var vehicleCrosswalkSegment = crosswalkPositionVector.subtract(new Vector([vehiclePosition.x, vehiclePosition.y]));

			var newDistanceToSource = vehicleCrossroadSegment.magnitude();
			var newDistanceToCrossing = vehicleCrosswalkSegment.magnitude();

			var carsOnCrossroad = this.getCarsOnCrossroad(this.roads[i].s2);
			var carsOnCrossroadWaiting = this.getCarsOnCrossroadWaiting(this.roads[i].s2);

			//current car is on crossroad
			var isOnCrossroad = $.inArray(this.roads[i].carsToSecond[j], carsOnCrossroad) != -1;

			//entering the crossroad
			if ( /*newDistanceToCrossing > this.cars[this.roads[i].carsToSecond[j]].distanceToCrossing && */ isOnCrossroad && !this.cars[this.roads[i].carsToSecond[j]].isOnCrossroad) {
				this.cars[this.roads[i].carsToSecond[j]].currentCrossroadId = this.roads[i].s2;
				this.cars[this.roads[i].carsToSecond[j]].chooseRandomDirection();
				if (!this.isCrossroadCorner(this.roads[i].s2)) {
					this.cars[this.roads[i].carsToSecond[j]].isWaiting = true;
					this.cars[this.roads[i].carsToSecond[j]].waitingStartTime = new Date();
				}
			}

			//this.carDebug(this.roads[i].carsToSecond[j]);
			this.cars[this.roads[i].carsToSecond[j]].isOnCrossroad = isOnCrossroad;

			if (this.cars[this.roads[i].carsToSecond[j]].isWaiting)
				continue;

			//vehicle reached the end of street
			if (newDistanceToSource > this.cars[this.roads[i].carsToSecond[j]].distanceToSource) {
				var carId = this.roads[i].carsToSecond[0];

				if (this.changeRoad(i, carId, crossroadIndex))
					this.roads[i].carsToSecond.shift();

				continue;
			}

			this.cars[this.roads[i].carsToSecond[j]].distanceToSource = vehicleCrossroadSegment.magnitude();
			this.cars[this.roads[i].carsToSecond[j]].distanceToCrossing = vehicleCrosswalkSegment.magnitude();

			//check if there's space between current car and next car
			if (j > 0) {
				var previousCarPosition = this.cars[this.roads[i].carsToSecond[j - 1]].getOriginalPosition();
				var currentCarPosition = this.cars[this.roads[i].carsToSecond[j]].getOriginalPosition();
				var carDistanceVector = new Vector([previousCarPosition.x, previousCarPosition.y]);
				carDistanceVector = carDistanceVector.subtract(new Vector([currentCarPosition.x, currentCarPosition.y]));
				var carDistance = carDistanceVector.magnitude();

				if (carDistance > this.cars[this.roads[i].carsToSecond[j - 1]].length + 10) {
					this.cars[this.roads[i].carsToSecond[j]].translate(translationVector);
				}
			} else {
				this.cars[this.roads[i].carsToSecond[j]].translate(translationVector);
			}
			if (logString.length > 1)
				logString += "<br>";


		}

		translationVector = translationVector.multiply(new Vector([-1, -1]));

		//for each car going to first crossroad
		for (j = 0; j < this.roads[i].carsToFirst.length; j++) {
			var vehiclePosition = this.cars[this.roads[i].carsToFirst[j]].getOriginalPosition();

			var crossroadIndex = this.roads[i].s1;

			vehicleCrossroadSegment = firstCrossroadPositionVector.subtract(new Vector([vehiclePosition.x, vehiclePosition.y]));
			vehicleCrossroadSegmentOpposite = vehicleCrossroadSegment.multiply(new Vector([-1, -1]));
			vehicleCrossroadSegmentOpposite.normalize();
			vehicleCrossroadSegmentOpposite = vehicleCrossroadSegmentOpposite.multiply(new Vector([this.crossroadOffset, this.crossroadOffset]));

			var crosswalkPositionVector = firstCrossroadPositionVector.add(vehicleCrossroadSegmentOpposite);
			var vehicleCrosswalkSegment = crosswalkPositionVector.subtract(new Vector([vehiclePosition.x, vehiclePosition.y]));

			var newDistanceToSource = vehicleCrossroadSegment.magnitude();
			var newDistanceToCrossing = vehicleCrosswalkSegment.magnitude();

			var carsOnCrossroad = this.getCarsOnCrossroad(this.roads[i].s1);
			var carsOnCrossroadWaiting = this.getCarsOnCrossroadWaiting(this.roads[i].s1);

			var isOnCrossroad = $.inArray(this.roads[i].carsToFirst[j], carsOnCrossroad) != -1;

			if ( /*newDistanceToCrossing > this.cars[this.roads[i].carsToFirst[j]].distanceToCrossing && */ isOnCrossroad && !this.cars[this.roads[i].carsToFirst[j]].isOnCrossroad) {
				this.cars[this.roads[i].carsToFirst[j]].currentCrossroadId = this.roads[i].s1;
				this.cars[this.roads[i].carsToFirst[j]].chooseRandomDirection();
				if (!this.isCrossroadCorner(this.roads[i].s1)) {
					this.cars[this.roads[i].carsToFirst[j]].isWaiting = true;
					this.cars[this.roads[i].carsToFirst[j]].waitingStartTime = new Date();
				}
			}

			this.cars[this.roads[i].carsToFirst[j]].isOnCrossroad = isOnCrossroad;

			//this.carDebug(this.roads[i].carsToFirst[j]);

			if (this.cars[this.roads[i].carsToFirst[j]].isWaiting)
				continue;

			//vehicle reached the end of street
			if (newDistanceToSource > this.cars[this.roads[i].carsToFirst[j]].distanceToSource) {
				var carId = this.roads[i].carsToFirst[0];

				if (this.changeRoad(i, carId, crossroadIndex))
					this.roads[i].carsToFirst.shift();

				continue;
			}

			this.cars[this.roads[i].carsToFirst[j]].distanceToSource = vehicleCrossroadSegment.magnitude();
			this.cars[this.roads[i].carsToFirst[j]].distanceToCrossing = vehicleCrosswalkSegment.magnitude();

			//check if there's space between current car and next car
			if (j > 0) {
				var previousCarPosition = this.cars[this.roads[i].carsToFirst[j - 1]].getOriginalPosition();
				var currentCarPosition = this.cars[this.roads[i].carsToFirst[j]].getOriginalPosition();
				var carDistanceVector = new Vector([previousCarPosition.x, previousCarPosition.y]);
				carDistanceVector = carDistanceVector.subtract(new Vector([currentCarPosition.x, currentCarPosition.y]));
				var carDistance = carDistanceVector.magnitude();

				if (carDistance > this.cars[this.roads[i].carsToFirst[j - 1]].length + 10) {
					this.cars[this.roads[i].carsToFirst[j]].translate(translationVector);
				}
			} else {
				this.cars[this.roads[i].carsToFirst[j]].translate(translationVector);
			}
			if (logString.length > 1)
				logString += "<br>";
		}
	}

	for (j = 1; j < this.crossroads.length; j++) {
		var carsOnCrossroad = this.getCarsOnCrossroad(j);
		var carsOnCrossroadWaiting = this.getCarsOnCrossroadWaiting(j);
		if (carsOnCrossroadWaiting.length == carsOnCrossroad.length) {
			this.wakeRandomWaitingCar(j);
		}
		for (var a = 0; a < carsOnCrossroadWaiting.length; a++) {
			this.wakeWaitingCarIfPossible(carsOnCrossroadWaiting[a], j, carsOnCrossroad);
		}
	}

	var carsOnCrossroad = this.getCarsOnCrossroad(5);
	var carsOnCrossroadWaiting = this.getCarsOnCrossroadWaiting(5);
	logString = "";
	for (a = 0; a < carsOnCrossroad.length; a++) {
		logString += this.cars[carsOnCrossroad[a]].name + " ";
	}
	logString += "<br />";
	for (a = 0; a < carsOnCrossroadWaiting.length; a++) {
		logString += this.cars[carsOnCrossroad[a]].name + " ";
	}
	$(".infoBox").html(logString);
	logString = "";
}

$(document).ready(function() {

	//$('<div style="position: fixed; top:100px; left: 100px; z-index:9999; background-color:white; padding:10px;" class="infoBox"> TEST</div>').appendTo( "body" );/
});

Traffic.prototype.getPossibleRoads = function(crossroadId, currentRoadId) {
	var firstRoad = this.crossroads[crossroadId].eastNorth;
	var secondRoad = this.crossroads[crossroadId].eastSouth;
	var thirdRoad = this.crossroads[crossroadId].westNorth;
	var fourthRoad = this.crossroads[crossroadId].westSouth;

	var possibleRoads = [];

	if (!(firstRoad == currentRoadId || firstRoad == null))
		possibleRoads.push(firstRoad);
	if (!(secondRoad == currentRoadId || secondRoad == null))
		possibleRoads.push(secondRoad);
	if (!(thirdRoad == currentRoadId || thirdRoad == null))
		possibleRoads.push(thirdRoad);
	if (!(fourthRoad == currentRoadId || fourthRoad == null))
		possibleRoads.push(fourthRoad);

	return possibleRoads;
}

Traffic.prototype.changeRoad = function(currentRoadId, carId, crossroadIndex) {
	var randomRoad;

	if (this.cars[carId].currentCrossroad == null) {
		this.cars[carId].currentCrossroadId = crossroadIndex;
		this.cars[carId].chooseRandomDirection();
	}

	var turnSignal = this.cars[carId].turnSignal;
	if (turnSignal == "southWest")
		randomRoad = this.crossroads[crossroadIndex].westSouth;
	if (turnSignal == "southEast")
		randomRoad = this.crossroads[crossroadIndex].eastSouth;
	if (turnSignal == "northWest")
		randomRoad = this.crossroads[crossroadIndex].westNorth;
	if (turnSignal == "northEast")
		randomRoad = this.crossroads[crossroadIndex].eastNorth;

	if (this.roads[randomRoad] == undefined) {
		return true;
	}

	if (this.roads[randomRoad].s1 == crossroadIndex) {
		if (this.roads[randomRoad].carsToSecond.length > 0) {
			var lastCarPosition = this.cars[this.roads[randomRoad].carsToSecond[this.roads[randomRoad].carsToSecond.length - 1]].getOriginalPosition();
			var lastCarDistanceFromCrossroadVector = new Vector([lastCarPosition.x - this.crossroads[this.roads[randomRoad].s1].position.x, lastCarPosition.y - this.crossroads[this.roads[randomRoad].s1].position.y]);
			var lastCarDistanceFromCrossroad = lastCarDistanceFromCrossroadVector.magnitude();
			if (lastCarDistanceFromCrossroad - this.cars[this.roads[randomRoad].carsToSecond[this.roads[randomRoad].carsToSecond.length - 1]].length < this.cars[carId].length) {
				return false;
			}
		}

		this.roads[randomRoad].carsToSecond.push(carId);

		if (!this.cars[carId].goesToSecondCrossroad)
			this.cars[carId].goesToSecondCrossroad = true;

		var currentOrientation = this.orientationFromPoints(this.crossroads[this.roads[randomRoad].s1].position, this.crossroads[this.roads[randomRoad].s2].position);


		if (currentOrientation != this.cars[carId].bitmap.currentAnimation || currentRoadId >= 88 && currentRoadId <= 103) {
			this.cars[carId].bitmap.x = this.crossroads[this.roads[randomRoad].s1].position.x;
			this.cars[carId].bitmap.y = this.crossroads[this.roads[randomRoad].s1].position.y;
			//this.cars[carId].setPosition({x:this.crossroads[this.roads[randomRoad].s1].position.x,y:this.crossroads[this.roads[randomRoad].s1].position.y});
			var translationVector = new Vector([this.crossroads[this.roads[randomRoad].s2].position.x, this.crossroads[this.roads[randomRoad].s2].position.y]);
			translationVector = translationVector.subtract(new Vector([this.crossroads[this.roads[randomRoad].s1].position.x, this.crossroads[this.roads[randomRoad].s1].position.y]));
			translationVector.normalize();
			translationVector = translationVector.multiply(new Vector([this.cars[carId].length, this.cars[carId].length]));
			this.cars[carId].translate(translationVector);
			this.reorientCar(this.cars[carId], randomRoad);
		}

		// fixing car's layers
		if (this.cars[carId].bitmap.currentAnimation == 'southEast' || this.cars[carId].bitmap.currentAnimation == 'northEast') {
			var indexes = [];
			for (var a = 0; a < this.roads[randomRoad].carsToSecond.length; a++) {
				game.container.setChildIndex(this.cars[this.roads[randomRoad].carsToSecond[a]].bitmap, 10);
			}
			for (var a = 0; a < this.roads[randomRoad].carsToFirst.length; a++) {
				game.container.setChildIndex(this.cars[this.roads[randomRoad].carsToFirst[a]].bitmap, 2);
			}
		} else {
			var indexes = [];
			for (var a = 0; a < this.roads[randomRoad].carsToSecond.length; a++) {
				game.container.setChildIndex(this.cars[this.roads[randomRoad].carsToSecond[a]].bitmap, 2);
			}
			for (var a = 0; a < this.roads[randomRoad].carsToFirst.length; a++) {
				game.container.setChildIndex(this.cars[this.roads[randomRoad].carsToFirst[a]].bitmap, 10);
			}
		}
	} else {
		if (this.roads[randomRoad].carsToFirst.length > 0) {
			var lastCarPosition = this.cars[this.roads[randomRoad].carsToFirst[this.roads[randomRoad].carsToFirst.length - 1]].getOriginalPosition();
			var lastCarDistanceFromCrossroadVector = new Vector([lastCarPosition.x - this.crossroads[this.roads[randomRoad].s2].position.x, lastCarPosition.y - this.crossroads[this.roads[randomRoad].s2].position.y]);
			var lastCarDistanceFromCrossroad = lastCarDistanceFromCrossroadVector.magnitude();
			if (lastCarDistanceFromCrossroad - this.cars[this.roads[randomRoad].carsToFirst[this.roads[randomRoad].carsToFirst.length - 1]].length < this.cars[carId].length) {
				return false;
			}
		}

		this.roads[randomRoad].carsToFirst.push(carId);
		if (this.cars[carId].goesToSecondCrossroad)
			this.cars[carId].goesToSecondCrossroad = false;

		var currentOrientation = this.orientationFromPoints(this.crossroads[this.roads[randomRoad].s2].position, this.crossroads[this.roads[randomRoad].s1].position);

		if (currentOrientation != this.cars[carId].bitmap.currentAnimation || currentRoadId >= 88 && currentRoadId <= 103) {
			this.cars[carId].bitmap.x = this.crossroads[this.roads[randomRoad].s2].position.x;
			this.cars[carId].bitmap.y = this.crossroads[this.roads[randomRoad].s2].position.y;
			//this.cars[carId].setPosition({x:this.crossroads[this.roads[randomRoad].s2].position.x,y:this.crossroads[this.roads[randomRoad].s2].position.y});
			var translationVector = new Vector([this.crossroads[this.roads[randomRoad].s1].position.x, this.crossroads[this.roads[randomRoad].s1].position.y]);
			translationVector = translationVector.subtract(new Vector([this.crossroads[this.roads[randomRoad].s2].position.x, this.crossroads[this.roads[randomRoad].s2].position.y]));
			translationVector.normalize();
			translationVector = translationVector.multiply(new Vector([this.cars[carId].length, this.cars[carId].length]));
			this.cars[carId].translate(translationVector);
			this.reorientCar(this.cars[carId], randomRoad);
		}

		// fixing car's layers
		if (this.cars[carId].bitmap.currentAnimation == 'southEast' || this.cars[carId].bitmap.currentAnimation == 'northEast') {
			for (var a = 0; a < this.roads[randomRoad].carsToSecond.length; a++) {
				game.container.setChildIndex(this.cars[this.roads[randomRoad].carsToSecond[a]].bitmap, 2);
			}
			for (var a = 0; a < this.roads[randomRoad].carsToFirst.length; a++) {
				game.container.setChildIndex(this.cars[this.roads[randomRoad].carsToFirst[a]].bitmap, 10);
			}
		} else {
			for (var a = 0; a < this.roads[randomRoad].carsToSecond.length; a++) {
				game.container.setChildIndex(this.cars[this.roads[randomRoad].carsToSecond[a]].bitmap, 10);
			}
			for (var a = 0; a < this.roads[randomRoad].carsToFirst.length; a++) {
				game.container.setChildIndex(this.cars[this.roads[randomRoad].carsToFirst[a]].bitmap, 2);
			}
		}
	}

	this.cars[carId].distanceToSource = Number.MAX_VALUE;
	this.cars[carId].distanceToCrossing = Number.MAX_VALUE;


	for (var i = 0; i < window.game.map.pedestrians.length; i++) {
		window.game.container.setChildIndex(window.game.map.pedestrians[i].bitmap, 10);
	}

	return true;
}

Traffic.prototype.fixCarsLayer = function() {

}

Traffic.prototype.getCarsOnCrossroad = function(crossroadId) {
	var firstRoad = this.roads[this.crossroads[crossroadId].eastNorth];
	var secondRoad = this.roads[this.crossroads[crossroadId].eastSouth];
	var thirdRoad = this.roads[this.crossroads[crossroadId].westNorth];
	var fourthRoad = this.roads[this.crossroads[crossroadId].westSouth];

	var carsOnCrossroad = [];

	//first road
	if (firstRoad != undefined) {
		for (var i = 0; i < firstRoad.carsToFirst.length; i++) {
			if (this.carIsOnCrossroad(firstRoad.carsToFirst[i], crossroadId, "eastNorth"))
				carsOnCrossroad.push(firstRoad.carsToFirst[i]);
		}

		for (var i = 0; i < firstRoad.carsToSecond.length; i++) {
			if (this.carIsOnCrossroad(firstRoad.carsToSecond[i], crossroadId, "eastNorth"))
				carsOnCrossroad.push(firstRoad.carsToSecond[i]);
		}
	}
	//second road
	if (secondRoad != undefined) {
		for (var i = 0; i < secondRoad.carsToFirst.length; i++) {
			if (this.carIsOnCrossroad(secondRoad.carsToFirst[i], crossroadId, "eastSouth"))
				carsOnCrossroad.push(secondRoad.carsToFirst[i]);
		}

		for (var i = 0; i < secondRoad.carsToSecond.length; i++) {
			if (this.carIsOnCrossroad(secondRoad.carsToSecond[i], crossroadId, "eastSouth"))
				carsOnCrossroad.push(secondRoad.carsToSecond[i]);
		}
	}

	//third road
	if (thirdRoad != undefined) {
		for (var i = 0; i < thirdRoad.carsToFirst.length; i++) {
			if (this.carIsOnCrossroad(thirdRoad.carsToFirst[i], crossroadId, "westNorth"))
				carsOnCrossroad.push(thirdRoad.carsToFirst[i]);
		}

		for (var i = 0; i < thirdRoad.carsToSecond.length; i++) {
			if (this.carIsOnCrossroad(thirdRoad.carsToSecond[i], crossroadId, "westNorth"))
				carsOnCrossroad.push(thirdRoad.carsToSecond[i]);
		}
	}

	//fourth road
	if (fourthRoad != undefined) {
		for (var i = 0; i < fourthRoad.carsToFirst.length; i++) {
			if (this.carIsOnCrossroad(fourthRoad.carsToFirst[i], crossroadId, "westSouth"))
				carsOnCrossroad.push(fourthRoad.carsToFirst[i]);
		}

		for (var i = 0; i < fourthRoad.carsToSecond.length; i++) {
			if (this.carIsOnCrossroad(fourthRoad.carsToSecond[i], crossroadId, "westSouth"))
				carsOnCrossroad.push(fourthRoad.carsToSecond[i]);
		}
	}

	return carsOnCrossroad;
}

Traffic.prototype.wakeRandomWaitingCar = function(crossroadId) {
	var cars = this.getCarsOnCrossroadWaiting(crossroadId);
	var car = this.cars[cars[Math.floor(Math.random() * cars.length)]];
	if (car != undefined)
		car.isWaiting = false;
}

Traffic.prototype.wakeWaitingCarIfPossible = function(carId, crossroadId, carsOnCrossroad) {
	var possible = true;
	var turning = this.cars[carId].getTurning();
	for (var i = 0; i < carsOnCrossroad.length; i++) {
		if (this.cars[carsOnCrossroad[i]].isWaiting)
			continue;
		var secondTurning = this.cars[carsOnCrossroad[i]].turning;

		//if there's car on crossroad which is turning left and driving in different direction
		if (secondTurning == "left" && this.cars[carId].bitmap.currentAnimation != this.cars[carsOnCrossroad[i]].bitmap.currentAnimation) {
			possible = false;
		}

		//if there's car on crossroad which is driving straight but crossing current's line
		if (secondTurning == "straight" && turning == "straight" && this.cars[carsOnCrossroad[i]].turnSignal != this.cars[carId].bitmap.currentAnimation && this.cars[carsOnCrossroad[i]].turnSignal != this.getOppositeDirection(this.cars[carId].bitmap.currentAnimation)) {
			possible = false;
		}

		if (!(turning == "right" && (secondTurning == "right" || secondTurning == "straight")) && !turning == "straight")
			possible = false;

		if (turning == "left")
			possible = false;
	}

	if (possible)
		this.cars[carId].isWaiting = false;

	return possible;
}
Traffic.prototype.getOppositeDirection = function(direction) {
	if (direction == "northWest")
		return "southEast";
	else if (direction == "northEast")
		return "southWest";
	else if (direction == "southWest")
		return "northEast";
	else if (direction == "southEast")
		return "northWest";
}

Traffic.prototype.getCarsOnCrossroadWaiting = function(crossroadId) {
	var firstRoad = this.roads[this.crossroads[crossroadId].eastNorth];
	var secondRoad = this.roads[this.crossroads[crossroadId].eastSouth];
	var thirdRoad = this.roads[this.crossroads[crossroadId].westNorth];
	var fourthRoad = this.roads[this.crossroads[crossroadId].westSouth];

	var carsOnCrossroad = [];

	//first road
	if (firstRoad != undefined) {
		for (var i = 0; i < firstRoad.carsToFirst.length; i++) {
			if (this.carIsOnCrossroad(firstRoad.carsToFirst[i], crossroadId, "eastNorth") && this.cars[firstRoad.carsToFirst[i]].isWaiting)
				carsOnCrossroad.push(firstRoad.carsToFirst[i]);
		}

		for (var i = 0; i < firstRoad.carsToSecond.length; i++) {
			if (this.carIsOnCrossroad(firstRoad.carsToSecond[i], crossroadId, "eastNorth") && this.cars[firstRoad.carsToSecond[i]].isWaiting)
				carsOnCrossroad.push(firstRoad.carsToSecond[i]);
		}
	}
	//second road
	if (secondRoad != undefined) {
		for (var i = 0; i < secondRoad.carsToFirst.length; i++) {
			if (this.carIsOnCrossroad(secondRoad.carsToFirst[i], crossroadId, "eastSouth") && this.cars[secondRoad.carsToFirst[i]].isWaiting)
				carsOnCrossroad.push(secondRoad.carsToFirst[i]);
		}

		for (var i = 0; i < secondRoad.carsToSecond.length; i++) {
			if (this.carIsOnCrossroad(secondRoad.carsToSecond[i], crossroadId, "eastSouth") && this.cars[secondRoad.carsToSecond[i]].isWaiting)
				carsOnCrossroad.push(secondRoad.carsToSecond[i]);
		}
	}

	//third road
	if (thirdRoad != undefined) {
		for (var i = 0; i < thirdRoad.carsToFirst.length; i++) {
			if (this.carIsOnCrossroad(thirdRoad.carsToFirst[i], crossroadId, "westNorth") && this.cars[thirdRoad.carsToFirst[i]].isWaiting)
				carsOnCrossroad.push(thirdRoad.carsToFirst[i]);
		}

		for (var i = 0; i < thirdRoad.carsToSecond.length; i++) {
			if (this.carIsOnCrossroad(thirdRoad.carsToSecond[i], crossroadId, "westNorth") && this.cars[thirdRoad.carsToSecond[i]].isWaiting)
				carsOnCrossroad.push(thirdRoad.carsToSecond[i]);
		}
	}

	//fourth road
	if (fourthRoad != undefined) {
		for (var i = 0; i < fourthRoad.carsToFirst.length; i++) {
			if (this.carIsOnCrossroad(fourthRoad.carsToFirst[i], crossroadId, "westSouth") && this.cars[fourthRoad.carsToFirst[i]].isWaiting)
				carsOnCrossroad.push(fourthRoad.carsToFirst[i]);
		}

		for (var i = 0; i < fourthRoad.carsToSecond.length; i++) {
			if (this.carIsOnCrossroad(fourthRoad.carsToSecond[i], crossroadId, "westSouth") && this.cars[fourthRoad.carsToSecond[i]].isWaiting)
				carsOnCrossroad.push(fourthRoad.carsToSecond[i]);
		}
	}

	return carsOnCrossroad;
}

Traffic.prototype.carIsOnCrossroad = function(carId, crossroadId, roadOrientation) {
	var frontPosition = this.cars[carId].getOriginalPosition();
	var rearPosition = this.cars[carId].getOriginalRearPosition();

	switch (roadOrientation) {
		case "eastNorth":
			if (this.crossroads[crossroadId].eastNorth != null) {
				var crossingPoint = this.getPointBehindCrossing(crossroadId, "eastNorth");
				if (rearPosition.x < crossingPoint.x && rearPosition.y > crossingPoint.y ||
					frontPosition.x < crossingPoint.x && frontPosition.y > crossingPoint.y)
					return true;
			}
			break;
		case "eastSouth":
			if (this.crossroads[crossroadId].eastSouth != null) {
				var crossingPoint = this.getPointBehindCrossing(crossroadId, "eastSouth");
				if (rearPosition.x < crossingPoint.x && rearPosition.y < crossingPoint.y ||
					frontPosition.x < crossingPoint.x && frontPosition.y < crossingPoint.y)
					return true;
			}
			break;
		case "westNorth":
			if (this.crossroads[crossroadId].westNorth != null) {
				var crossingPoint = this.getPointBehindCrossing(crossroadId, "westNorth");
				if (rearPosition.x > crossingPoint.x && rearPosition.y > crossingPoint.y ||
					frontPosition.x > crossingPoint.x && frontPosition.y > crossingPoint.y)
					return true;
			}
			break;
		case "westSouth":
			if (this.crossroads[crossroadId].westSouth != null) {
				var crossingPoint = this.getPointBehindCrossing(crossroadId, "westSouth");
				if (rearPosition.x > crossingPoint.x && rearPosition.y < crossingPoint.y ||
					frontPosition.x > crossingPoint.x && frontPosition.y < crossingPoint.y)
					return true;
			}
			break;
	}

	return false;
}

Traffic.prototype.getPointBehindCrossing = function(crossroadId, orientation) {
	var firstCrossroadPosition = this.crossroads[crossroadId].position;
	var secondCrossroadPosition = null;

	var secondCrossroadId = this.getNeighborCrossroad(crossroadId, orientation);
	secondCrossroadPosition = this.crossroads[secondCrossroadId].position;

	var firstCrossroadPositionVector = new Vector([firstCrossroadPosition.x, firstCrossroadPosition.y]);
	var secondCrossroadPositionVector = new Vector([secondCrossroadPosition.x, secondCrossroadPosition.y]);
	var translationVector = secondCrossroadPositionVector.subtract(firstCrossroadPositionVector);
	translationVector.normalize();
	translationVector = translationVector.multiply(new Vector([this.crossroadOffset, this.crossroadOffset]));

	var resultPoint = firstCrossroadPositionVector.add(translationVector);

	return {
		x: resultPoint.items[0],
		y: resultPoint.items[1]
	};
}

Traffic.prototype.getNeighborCrossroad = function(crossroadId, orientation) {
	var secondCrossroadId = null;
	var roadId = null;
	switch (orientation) {
		case "eastNorth":
			roadId = this.crossroads[crossroadId].eastNorth;
			break;
		case "westNorth":
			roadId = this.crossroads[crossroadId].westNorth;
			break;
		case "eastSouth":
			roadId = this.crossroads[crossroadId].eastSouth;
			break;
		case "westSouth":
			roadId = this.crossroads[crossroadId].westSouth;
			break;
	}
	//	if(secondCrossroadId == undefined)
	//		return undefined;
	//console.log(crossroadId+" "+orientation);
	if (this.roads[roadId] == undefined)
		return;
	secondCrossroadId = this.roads[roadId].s1;

	if (secondCrossroadId == crossroadId)
		secondCrossroadId = this.roads[roadId].s2;

	return secondCrossroadId;
}

Traffic.prototype.isCrossroadCorner = function(crossroadId) {
	var numberOfRoads = 0;
	if (this.crossroads[crossroadId].eastNorth != null)
		numberOfRoads++;
	if (this.crossroads[crossroadId].westSouth != null)
		numberOfRoads++;
	if (this.crossroads[crossroadId].eastSouth != null)
		numberOfRoads++;
	if (this.crossroads[crossroadId].westNorth != null)
		numberOfRoads++;

	return numberOfRoads == 2;
}

Traffic.prototype.showLines = function() {
	/*var g = new createjs.Graphics();
	g.setStrokeStyle(1);
	g.beginStroke(createjs.Graphics.getRGB(255,0,0));
	g.beginFill(createjs.Graphics.getRGB(255,0,0));
	var s = new createjs.Shape(g);
		s.x = 100;
		s.y = 100;
	s.graphics.lineTo(1000,1000);
	window.game.stage.addChild(s);

	var graphics = new createjs.Graphics().beginFill("#ff0000").drawRect(0, 0, 100, 100);
	var shape = new createjs.Shape(graphics);

	window.game.stage.update(event);
	*/


	var g = new createjs.Graphics();
	g.setStrokeStyle(1);
	g.beginStroke(createjs.Graphics.getRGB(0, 0, 0));
	g.beginFill(createjs.Graphics.getRGB(255, 0, 0));
	g.drawCircle(0, 0, 3);
	var s = new createjs.Shape(g);
	s.x = 100;
	s.y = 100;

	window.game.stage.addChild(s);
	//window.game.stage.update();

	//this.putCircle({x: this.crossroads[5].position.x, y:this.crossroads[5].position.y});
	/*
		this.putCircle(this.getPointBehindCrossing(5, "eastNorth"));
		console.log(this.getPointBehindCrossing(5, "eastNorth"));
		this.putCircle(this.getPointBehindCrossing(5, "westSouth"));
		console.log(this.getPointBehindCrossing(5, "westSouth"));
		this.putCircle(this.getPointBehindCrossing(5, "eastSouth"));
		console.log(this.getPointBehindCrossing(5, "eastSouth"));
		this.putCircle(this.getPointBehindCrossing(5, "westNorth"));
		console.log(this.getPointBehindCrossing(5, "westNorth"));*/
}

Traffic.prototype.putCircle = function(position) {
	var circle = new createjs.Shape();
	circle.graphics.beginFill("red").drawCircle(0, 0, 5);
	//Set position of Shape instance.
	//circle.x = circle.y = 50;
	circle.x = position.x;
	circle.y = position.y;
	//Add Shape instance to stage display list.
	window.game.map.container.addChild(circle);
}

Traffic.prototype.drawLine = function(position, position2) {
	this.g = new createjs.Graphics();
	this.g.setStrokeStyle(1);
	this.g.beginStroke(createjs.Graphics.getRGB(255, 0, 0));
	this.g.beginFill(createjs.Graphics.getRGB(255, 0, 0));
	//g.drawCircle(0,0,3);
	this.s = new createjs.Shape(this.g);
	//s/.x = firstCrossroad.position.x;
	//s.y = firstCrossroad.position.y;
	this.s.graphics.moveTo(position.x, position.y);
	this.s.graphics.lineTo(position2.x, position2.y);
	window.game.map.container.addChildAt(this.s, window.game.map.container.children.length);
}

Traffic.prototype.crossroadDebug = function(crossroadId) {
	this.removeNewElements();
	var previousChildrenLength = window.game.container.children.length;

	var firstCrossroad = this.getNeighborCrossroad(crossroadId, "eastNorth");
	var secondCrossroad = this.getNeighborCrossroad(crossroadId, "eastSouth");
	var thirdCrossroad = this.getNeighborCrossroad(crossroadId, "westNorth");
	var fourthCrossroad = this.getNeighborCrossroad(crossroadId, "westSouth");

	if (firstCrossroad != undefined)
		this.drawLine(this.crossroads[crossroadId].position, this.crossroads[firstCrossroad].position);

	if (secondCrossroad != undefined)
		this.drawLine(this.crossroads[crossroadId].position, this.crossroads[secondCrossroad].position);

	if (thirdCrossroad != undefined)
		this.drawLine(this.crossroads[crossroadId].position, this.crossroads[thirdCrossroad].position);

	if (fourthCrossroad != undefined)
		this.drawLine(this.crossroads[crossroadId].position, this.crossroads[fourthCrossroad].position);
	this.numerOfNewElements = window.game.container.children.length - previousChildrenLength;
	return this.numerOfNewElements;
}

Traffic.prototype.removeNewElements = function() {
	for (var i = 0; i < this.numerOfNewElements; i++) {
		window.game.container.removeChildAt(window.game.container.children.length - 1);
	}
	this.numerOfNewElements = 0;
}

Traffic.prototype.carDebug = function(carId) {
	var currDate = new Date();
	if ($("#car_" + carId).length == 0) {
		//$("body").append('<div id="car_'+carId+'" style="position: absolute; background-color: white;">'+this.cars[carId].distanceToSource+'</div>');
		//$("body").append('<div id="car_'+carId+'" style="position: absolute; background-color: white;">'+this.cars[carId].isWaiting+'</div>');
		$("body").append('<div id="car_' + carId + '" style="position: absolute; background-color: white;">' + this.cars[carId].waitingStartTime + '</div>');

	}
	var newPosition = window.game.map.bitmap.localToGlobal(this.cars[carId].bitmap.x, this.cars[carId].bitmap.y);
	$("#car_" + carId).css("top", newPosition.y);
	$("#car_" + carId).css("left", newPosition.x);
	$("#car_" + carId).text(currDate - this.cars[carId].waitingStartTime);
}


// + poprawić warstwy
// - poprawić miejsce przeskoku samochodu
// - zablokować pokrywanie samochodu
// - stworzyć warunek wejścia na skrzyzowanie
// - samochody zatrzymywać przed przejściem
// + wyklikać pozostałe ścieżki
// + obsługa czteropasmówki
